#!/bin/bash
SHADOW_MODEL_IDX=$1
NUM_SHADOW=$2

SEED=0

NUM_CANARIES=500
CANARY_TYPE="label_noise"
NUM_POISON=0
POISON_TYPE="canary_duplicates"

EXPERIMENT="dfkd"

EXPERIMENT_DIR="exps"
DATA_DIR="datasets"
TEACHER_DIR="exps/cifar10/ckpts_ResNet18BN"
LIRA_PATH="${EXPERIMENT_DIR}/${EXPERIMENT}/lira"
SAVE_PATH="${EXPERIMENT_DIR}/${EXPERIMENT}/syn_img"

echo "Running task ${SLURM_ARRAY_TASK_ID} experiment ${EXPERIMENT}, shadow model ${SHADOW_MODEL_IDX}"
echo "Canaries: ${NUM_CANARIES} (${CANARY_TYPE}), poisons: ${NUM_POISON} (${POISON_TYPE})"

python -u src/dfkd/dfkd.py --experiment-dir "${EXPERIMENT_DIR}" --experiment "${EXPERIMENT}" \
    --data-dir "${DATA_DIR}" --lira_path $LIRA_PATH --save_path $SAVE_PATH \
    --seed "${SEED}" --num-shadow "${NUM_SHADOW}" --teacher_dir "${TEACHER_DIR}" \
    --num-canaries "${NUM_CANARIES}" --canary-type "${CANARY_TYPE}" \
    --num-poison "${NUM_POISON}" --poison-type "${POISON_TYPE}" \
    --shadow-model-idx "${SHADOW_MODEL_IDX}"
